/**
 * Login screen
 * @param {Core} owner
 */
var Login = new Class({
	owner: null,
  scr: null,
  el: null,
  
  initialize: function(owner){
    // associate static method to instance of object
    this.resetLoginInfo = Login.resetLoginInfo;
    
		this.owner = owner;
    this.scr = new Template("login");
    this.el = new Element('div').adopt(this.scr.xml).getFirst();
		this.addFormEvents();
				
		// Try to load saved login + password
		var saved_login = this.loadLoginInfo();
		if($defined(saved_login) && saved_login){			
			// log user in
			this.doLogin(
			  saved_login.login, saved_login.pass, 
			  null, // onSuccess
			  this.resetLoginInfo.bind(this) // onFailure
			);
		}
  },
	
	saveLoginInfo: function(login, pass){	
		var bytes = new air.ByteArray(); 
		bytes.writeUTFBytes(login);
		air.EncryptedLocalStore.setItem("login", bytes); 
		
    var bytes = new air.ByteArray(); 
    bytes.writeUTFBytes(pass);
    air.EncryptedLocalStore.setItem("pass", bytes);
	},
	
	loadLoginInfo: function(){
		stored_login = air.EncryptedLocalStore.getItem("login");
		stored_pass = air.EncryptedLocalStore.getItem("pass");
		
		if($defined(stored_login) && $defined(stored_pass)){
			return {'login': stored_login.readUTFBytes(stored_login.length), 'pass': stored_pass.readUTFBytes(stored_pass.length)};
		} else {
			return false;
		}
	},
	
	// static resetLoginInfo: function(){}
	// defined at the end of the file
	
	// registers event listeners
	addFormEvents: function(){
    var t = this;
		this.el.addEvent('domready', function(){
			this.getElement('input[name=login]').focus();
		});
		
		this.el.getElement("form").addEvent('submit', function(e){
      e.stop();
			t.submit(this);
		});
		
		this.el.getElement('a[id=register]').addEvent('click', function(e){
			e.stop();
			t.fireEvent('SectionChange', 'registration');
		});
		
		this.el.getElement('a[id=unregistered]').addEvent('click', function(e){
			e.stop();
			t.unregisteredLogin();
		});
    return this;
	},
	
	doLogin: function(login, pass, onSuccess, onFailure, onError){
    // do login request on server
    this.owner.server.request({'action': 'login', 'args': {'login': login, 'pass': pass}}, function(response){
			
      // wrong response
      if(!$defined(response)){
        if($defined(onError)){
					onFailure(response);
				} else {
          showError('Nepodarilo sa pripojiť - skúste to prosím neskôr.');
				}
        return;
    
      // login failed
      } else if($defined(response.error)) {
				if($defined(onFailure)) onFailure(response);
        
      // login was successful
      } else if($defined(response.user) && $defined(response.contacts)){
				if($defined(onSuccess)){
					onSuccess(response);
				} else {
	        this.owner.user = new User(this.owner, response.user);
	        this.owner.user.loadContacts(response.contacts);
	        this.fireEvent('SectionChange', 'main');
        }
      } else {
				showError('Vyskytla sa neznáma chyba.');
			}
    }.bind(this));
	},
	
	unregisteredLogin: function(){
    // get new anonymous user
    this.owner.server.request({'action': 'registration_anonymous', 'args': {}}, function(response){
			
      // wrong response
      if(!$defined(response)){
        showError('Nepodarilo sa vytvoriť anonymného používateľa - skúste to prosím znovu.');
        return;
				
      // login was successful
      } else if($defined(response.login) && $defined(response.pass)){
				this.saveLoginInfo(response.login, response.pass);
				this.doLogin(response.login, response.pass);
      }
		}.bind(this));      
	},
	
	// submits login form
	submit: function(form){
    // assign elements 
    var loginel = this.el.getElement('input[name=login]');
    var passel = this.el.getElement('input[name=password]');
    var submitel = this.el.getElement('input[type=submit]');
    
    // check fields
    if(loginel.value.length == 0){
      showMessage('Zadajte prosím používateľské meno');
      return false;
    }
    
    if(passel.value.length == 0){
      showMessage('Zadajte prosím heslo');
      return false;
    }

    var login = SHA256(loginel.value);
    var pass = SHA256(passel.value);
		
		var onFailure = function(){
      passel.value = '';
      loginel.value = '';
			loginel.focus();
		}.bind(this);
		
		var onSuccess = function(response){
			if (this.el.getElement('input[name=autologin]').checked) {
		  	this.saveLoginInfo(login, pass);
		  }
      this.owner.user = new User(this.owner, response.user);
      this.owner.user.loadContacts(response.contacts);
      this.fireEvent('SectionChange', 'main');
		}.bind(this);
		
		this.doLogin(login, pass, onSuccess, onFailure, null);
		
    return this;
	},
			
	getEl: function(){
		return this.el;
	}
});

Login.resetLoginInfo = function(){
  air.EncryptedLocalStore.removeItem("login");
  air.EncryptedLocalStore.removeItem("pass");
};

Login.implement(new Events);